/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.ce.wfeventhandler;

import com.filenet.api.admin.IsolatedRegion;
import com.filenet.api.admin.PEConnectionPoint;
import com.filenet.api.collection.PEConnectionPointSet;
import com.filenet.api.collection.PropertyDescriptionList;
import com.filenet.api.collection.StringList;
import com.filenet.api.constants.Cardinality;
import com.filenet.api.constants.FilteredPropertyType;
import com.filenet.api.constants.TypeID;
import com.filenet.api.constants.VersionStatus;
import com.filenet.api.core.CustomObject;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.ReferentialContainmentRelationship;
import com.filenet.api.core.VersionSeries;
import com.filenet.api.engine.EventActionHandler;
import com.filenet.api.events.ClassWorkflowSubscription;
import com.filenet.api.events.FileEvent;
import com.filenet.api.events.InstanceWorkflowSubscription;
import com.filenet.api.events.ObjectChangeEvent;
import com.filenet.api.events.Subscription;
import com.filenet.api.events.UnfileEvent;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.constants.Constants;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.J2EEUtilWS;
import com.filenet.engine.context.CallState;
import filenet.vw.api.VWCreateLiveWOResult;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWVersion;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.VWBootstrapURL;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WorkflowEventActionHandler
implements EventActionHandler {
    static final String classname;
    private Logger logger = Logger.getLogger("filenet.pe.ce.wfeventhandler");
    private static final String VW_VERSION_NUM1 = "1";
    private static final String VW_VERSION_NUM3 = "3";
    private StringList m_propertyMap = null;
    private String[] m_properties = null;
    private IndependentObject m_source = null;
    private Id m_sourceId = null;
    private VWVersion m_vwVersion = null;
    private String[] m_launchFields = null;
    private Object[] m_launchValues = null;
    private Subscription sub = null;

    public static String _get_FILE_DATE() {
        return "$Date:   02 Nov 2007 14:50:18  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   jluo  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.32  $";
    }

    public void onEvent(ObjectChangeEvent event, Id subId) throws EngineRuntimeException {
        String method = "onEvent";
        this.printDebug(method, "Enter");
        if (this.logger.isFinest()) {
            this.logger.finest(classname, method, " event=" + event.getClass().getName() + " " + event.getClassName() + ", source=" + event.get_SourceObject().getClass().getName() + ", source class id=" + event.get_SourceClassId());
        }
        ObjectStore objStore = event.getObjectStore();
        Id clsId = Constants.Class_Subscription;
        PropertyFilter pf = new PropertyFilter();
        try {
            Method m = objStore.getClass().getMethod("fetchObject", String.class, String.class, pf.getClass());
            this.sub = (Subscription)m.invoke((Object)objStore, clsId.toString(), subId.toString(), pf);
        }
        catch (NoSuchMethodException e) {
            throw new EngineRuntimeException((Throwable)e, ExceptionCode.EVENT_HANDLER_THREW, null);
        }
        catch (InvocationTargetException e) {
            throw new EngineRuntimeException((Throwable)e, ExceptionCode.EVENT_HANDLER_THREW, null);
        }
        catch (IllegalAccessException e) {
            throw new EngineRuntimeException((Throwable)e, ExceptionCode.EVENT_HANDLER_THREW, null);
        }
        boolean isTransactionSuspended = false;
        try {
            if (J2EEUtil.getInstance() instanceof J2EEUtilWS && !this.sub.get_IsSynchronous().booleanValue()) {
                CallState.getCallContext().suspendTransaction();
                isTransactionSuspended = true;
            }
            boolean canGetSourceObj = true;
            try {
                this.getSourceObj(event);
            }
            catch (Exception e) {
                this.logger.severe(classname, method, "cannot get event source.");
                canGetSourceObj = false;
            }
            if (!canGetSourceObj || this.m_source == null) {
                if (this.m_source == null) {
                    this.logger.severe(classname, method, "cannot get event source object.");
                }
                this.getWorkflowFields(event, this.sub, false);
                this.launchWorkflow(event, this.sub, null, null);
            } else {
                String[] fields = this.getWorkflowFields(event, this.sub, true);
                Object[] propertyValues = null;
                if (fields != null) {
                    propertyValues = this.getPropertyValues(event, this.sub);
                } else {
                    fields = new String[2];
                    propertyValues = new Object[2];
                }
                this.fillInAttachment(fields, propertyValues, event, this.sub);
                this.launchWorkflow(event, this.sub, propertyValues, fields);
            }
        }
        catch (EngineRuntimeException t) {
            this.printError("WorkflowEventHandler EngineRuntimeException: ", t);
            throw t;
        }
        catch (VWException t) {
            this.printError("WorkflowEventHandler VWException: ", t);
            throw new EngineRuntimeException((Throwable)t, ExceptionCode.EVENT_HANDLER_THREW, null);
        }
        catch (Throwable t) {
            this.printError("WorkflowEventHandler exception: ", t);
            throw new EngineRuntimeException(t, ExceptionCode.EVENT_HANDLER_THREW, null);
        }
        finally {
            if (isTransactionSuspended) {
                try {
                    CallState.getCallContext().resumeTransaction();
                }
                catch (Throwable t) {
                    this.printError("Resume transaction exception: ", t);
                    throw new EngineRuntimeException(t, ExceptionCode.EVENT_HANDLER_THREW, null);
                }
            }
            this.m_launchFields = null;
            this.m_launchValues = null;
        }
        this.printDebug(method, "WorkflowEventHandler onEvent Exit: ");
    }

    private String[] getWorkflowFields(ObjectChangeEvent event, Subscription sub, boolean expectFields) throws VWException {
        String strversion;
        String method = "getWorkflowFields";
        if (sub instanceof ClassWorkflowSubscription) {
            ClassWorkflowSubscription cws = (ClassWorkflowSubscription)sub;
            this.m_propertyMap = cws.get_PropertyMap();
            strversion = cws.get_VWVersion();
            if (this.logger.isFinest()) {
                this.logger.finest(classname, method, "WorkflowEventHandler Subscription = ClassWorkflowSubscription vwversion = " + strversion);
            }
            this.m_vwVersion = new VWVersion(strversion);
        } else if (sub instanceof InstanceWorkflowSubscription) {
            InstanceWorkflowSubscription iws = (InstanceWorkflowSubscription)sub;
            this.m_propertyMap = iws.get_PropertyMap();
            strversion = iws.get_VWVersion();
            if (this.logger.isFinest()) {
                this.logger.finest(classname, method, "WorkflowEventHandler Subscription = InstanceWorkflowSubscription vwversion = " + strversion);
            }
            this.m_vwVersion = new VWVersion(strversion);
        } else {
            this.printWarning(method, "The subscription is not a workflow subscription");
        }
        if (!expectFields || this.m_propertyMap == null || this.m_propertyMap.size() == 0) {
            return null;
        }
        String[] fields = new String[this.m_propertyMap.size() + 2];
        this.m_properties = new String[this.m_propertyMap.size()];
        for (int i = 0; i < this.m_propertyMap.size(); ++i) {
            String onemap = (String)this.m_propertyMap.get(i);
            if (this.logger.isFinest()) {
                this.logger.finest(classname, method, "WorkflowEventHandler property map: " + onemap);
            }
            fields[i] = onemap.substring(0, onemap.lastIndexOf("="));
            this.m_properties[i] = onemap.substring(onemap.lastIndexOf("=") + 1, onemap.length());
            if (this.logger.isFinest()) {
                this.logger.finest(classname, method, "WorkflowEventHandler field: " + fields[i]);
            }
            if (!this.logger.isFinest()) continue;
            this.logger.finest(classname, method, "WorkflowEventHandler property: " + this.m_properties[i]);
        }
        return fields;
    }

    private Object[] getPropertyValues(ObjectChangeEvent event, Subscription sub) {
        String method = "getPropertyValues";
        Object[] propertyValues = new Object[this.m_propertyMap.size() + 2];
        Properties props = null;
        try {
            props = this.m_source.getProperties();
        }
        catch (EngineRuntimeException e) {
            if (e.getExceptionCode() == ExceptionCode.API_PROPERTY_NOT_IN_CACHE) {
                // empty if block
            }
        }
        if (props != null) {
            if (this.logger.isFinest()) {
                this.logger.finest(classname, method, "WorkflowEventHandler get number of properties of the event source: " + props.size());
                Iterator it = props.iterator();
                while (it.hasNext()) {
                    this.logger.finest(classname, method, "WorkflowEventHandler get properties of the event source: " + ((Property)it.next()).getPropertyName());
                }
            }
        } else {
            this.printWarning(method, "WorkflowEventHandler get properties of the event source: none returned.");
            return null;
        }
        int size = this.m_propertyMap.size();
        if (size > 0) {
            ClassDescription clsDes = this.m_source.get_ClassDescription();
            PropertyFilter pf = new PropertyFilter();
            pf.addIncludeProperty(1, null, null, "PropertyDescriptions");
            pf.addIncludeType(1, null, null, FilteredPropertyType.ANY_LIST);
            pf.addIncludeType(1, null, null, FilteredPropertyType.ANY_SINGLETON);
            clsDes.fetchProperties(pf);
            PropertyDescriptionList pdl = clsDes.get_PropertyDescriptions();
            for (int j = 0; j < size; ++j) {
                if (!props.isPropertyPresent(this.m_properties[j])) {
                    propertyValues[j] = null;
                    if (!this.logger.isFinest()) continue;
                    this.logger.finest(classname, method, "WorkflowEventHandler: the property is not present at event source object. " + this.m_properties[j]);
                    continue;
                }
                Iterator pdIt = pdl.iterator();
                Cardinality cardinality = null;
                TypeID tid = null;
                boolean foundProperty = false;
                while (pdIt.hasNext()) {
                    PropertyDescription pd = (PropertyDescription)pdIt.next();
                    pd.getProperties();
                    try {
                        if (pd.get_SymbolicName().compareToIgnoreCase(this.m_properties[j]) != 0) continue;
                        cardinality = pd.get_Cardinality();
                        tid = pd.get_DataType();
                        if (this.logger.isFinest()) {
                            this.logger.finest(classname, method, "type of " + this.m_properties[j] + " is " + tid);
                        }
                        foundProperty = true;
                        break;
                    }
                    catch (EngineRuntimeException e) {
                        if (e.getExceptionCode() != ExceptionCode.API_PROPERTY_NOT_IN_CACHE) continue;
                    }
                }
                if (!foundProperty) continue;
                propertyValues[j] = this.getPropertyValue(j, props, tid, cardinality);
            }
        }
        return propertyValues;
    }

    private Object getPropertyValue(int j, Properties props, TypeID tid, Cardinality cardinality) {
        String method = "getPropertyValue";
        if (cardinality.equals(Cardinality.LIST)) {
            List objList = (List)props.getObjectValue(this.m_properties[j]);
            if (objList != null) {
                return objList.toArray();
            }
            return null;
        }
        if (cardinality.equals(Cardinality.SINGLE)) {
            Object propertyValue = null;
            propertyValue = props.getObjectValue(this.m_properties[j]);
            if (this.logger.isFinest()) {
                this.logger.finest(classname, method, "WorkflowEventHandler property value: " + propertyValue);
            }
            return propertyValue;
        }
        this.printWarning(method, "WorkflowEventHandler: this cardinality of property is not supported in property mapping: " + this.m_properties[j]);
        return null;
    }

    private void fillInAttachment(String[] fields, Object[] propertyValues, ObjectChangeEvent event, Subscription sub) {
        String method = "fillInAttachment";
        int size = fields.length;
        fields[size - 1] = "F_Text";
        fields[size - 2] = "F_MAINATTACHMENT";
        ObjectStore objStore = event.getObjectStore();
        objStore.refresh();
        String sourceString = null;
        if (this.m_source instanceof VersionSeries) {
            this.printDebug(method, "event source is version series.");
            sourceString = this.versionSeriesString((VersionSeries)this.m_source, objStore.get_Name());
        } else {
            sourceString = this.m_source instanceof Document ? this.documentString((Document)this.m_source, objStore.get_Name()) : (this.m_source instanceof Folder ? this.folderString((Folder)this.m_source, objStore.get_Name()) : (this.m_source instanceof CustomObject ? this.customObjString((CustomObject)this.m_source, objStore.get_Name()) : this.otherObjString((EngineObject)this.m_source, objStore.get_Name())));
        }
        propertyValues[size - 2] = sourceString;
        StringBuffer f_text = new StringBuffer("This workflow is launched by CE event ");
        f_text.append(event.getClassName());
        f_text.append(" on object (guid=");
        f_text.append(sourceString);
        f_text.append(") in object store (guid=");
        f_text.append(objStore.get_Id());
        propertyValues[size - 1] = f_text.toString();
    }

    private String versionSeriesString(VersionSeries vs, String objStoreName) {
        return vs.get_Id() + "||3|3|" + objStoreName + "|" + vs.get_Id();
    }

    private String documentString(Document doc, String objStoreName) {
        String method = "documentString";
        StringBuffer docSB = new StringBuffer();
        String docName = "";
        try {
            docName = doc.get_Name();
        }
        catch (EngineRuntimeException e) {
            if (e.getExceptionCode() == ExceptionCode.API_PROPERTY_NOT_IN_CACHE) {
                if (this.logger.isFinest()) {
                    this.logger.finest(classname, method, "API_PROPERTY_NOT_IN_CACHE for NAME, leave it empty");
                }
            }
            this.logger.log(Level.SEVERE, classname, method, e.getLocalizedMessage(), e);
        }
        try {
            docSB.append(docName + "||3|3|" + objStoreName + "|");
            if (doc.get_IsCurrentVersion().booleanValue()) {
                docSB.append(doc.get_VersionSeries().get_Id());
            } else if (doc.get_VersionStatus() == VersionStatus.RELEASED) {
                docSB.append(doc.get_VersionSeries().get_Id() + "|-1");
            } else {
                PropertyFilter pf = new PropertyFilter();
                pf.addIncludeProperty(0, null, null, "Id");
                VersionSeries vs = doc.get_VersionSeries();
                vs.fetchProperties(pf);
                docSB.append(vs.get_Id() + "|" + doc.get_Id());
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, classname, method, t.getLocalizedMessage(), t);
        }
        if (this.logger.isFinest()) {
            this.logger.finest(classname, method, docSB.toString());
        }
        return docSB.toString();
    }

    private String folderString(Folder folder, String objStoreName) {
        String method = "folderString";
        StringBuffer folderSB = new StringBuffer();
        folderSB.append(folder.get_Name() + "||2|3|" + objStoreName + "|" + folder.get_Id());
        if (this.logger.isFinest()) {
            this.logger.finest(classname, method, folderSB.toString());
        }
        return folderSB.toString();
    }

    private String customObjString(CustomObject customObj, String objStoreName) {
        String method = "customObjString";
        StringBuffer customObjSB = new StringBuffer();
        customObjSB.append(customObj.get_Id() + "||6|3|" + objStoreName + "|" + customObj.get_Id());
        if (this.logger.isFinest()) {
            this.logger.finest(classname, method, customObjSB.toString());
        }
        return customObjSB.toString();
    }

    private String otherObjString(EngineObject obj, String objStoreName) {
        String method = "otherObjString";
        StringBuffer objSB = new StringBuffer();
        String id = obj.getProperties().getIdValue("Id").toString();
        objSB.append(id + "||0|3|" + objStoreName + "|" + id);
        if (this.logger.isFinest()) {
            this.logger.finest(classname, method, objSB.toString());
        }
        return objSB.toString();
    }

    private void getSourceObj(ObjectChangeEvent event) {
        String method = "getSourceObj";
        Id sourceId = event.get_SourceObjectId();
        if (this.logger.isFinest()) {
            this.logger.finest(classname, method, "soruce id = " + sourceId.toString());
        }
        ObjectStore objStore = event.getObjectStore();
        if (this.logger.isFinest()) {
            this.logger.finest(classname, method, "object store = " + objStore.toString());
        }
        this.m_source = event.get_SourceObject();
        if (this.m_source instanceof ReferentialContainmentRelationship) {
            ReferentialContainmentRelationship rcr = (ReferentialContainmentRelationship)this.m_source;
            this.m_source = rcr.get_Tail();
        } else if (event instanceof FileEvent || event instanceof UnfileEvent) {
            Folder f = (Folder)this.m_source;
            this.m_source = f.get_Parent();
        }
    }

    private void launchWorkflow(ObjectChangeEvent event, Subscription sub, Object[] propertyValues, String[] fields) throws VWException, MalformedURLException {
        String method = "launchWorkflow";
        int region = this.m_vwVersion.getIsolatedRegion();
        String service = this.m_vwVersion.getServiceName();
        VWSession session = null;
        if (this.logger.isFinest()) {
            this.logger.finest(classname, method, "Region = " + region + service);
        }
        if (fields != null) {
            this.constructLaunchValues(fields, propertyValues);
            if (this.logger.isFinest()) {
                this.logger.finest(classname, method, this.m_launchFields.toString());
                this.logger.finest(classname, method, this.m_launchValues.toString());
            }
        } else {
            this.m_launchFields = new String[]{"F_Text"};
            this.m_launchValues = new String[]{"This workflow is launched by CE event " + event.getClassName()};
        }
        String versionOfVWVersion = this.m_vwVersion.getVersion();
        PEConnectionPoint connPoint = null;
        if (versionOfVWVersion.compareToIgnoreCase(VW_VERSION_NUM1) == 0) {
            connPoint = this.findPEConnectionPoint(sub, region, service, null);
        } else {
            String connPointName = this.m_vwVersion.getConnectionPoint();
            connPoint = this.findPEConnectionPoint(sub, region, service, connPointName);
        }
        String ceURI = connPoint.getConnection().getURI();
        if (this.logger.isFinest()) {
            this.logger.finest(classname, method, "ceURI = " + ceURI);
        }
        String vwBootstrapURL = new VWBootstrapURL(ceURI, connPoint.get_Name()).toString();
        if (this.logger.isFinest()) {
            this.logger.finest(classname, method, "VWBootstrapURL = " + vwBootstrapURL);
        }
        if (this.logger.isFinest()) {
            this.logger.finest(classname, method, "vwversion = " + this.m_vwVersion.toString());
        }
        VWCreateLiveWOResult[] result = null;
        try {
            session = this.getVWSession(vwBootstrapURL);
            result = session.createLiveWorkObject(this.m_launchFields, this.m_launchValues, this.m_vwVersion.toString(), 1);
            if (result != null && result[0].success()) {
                this.printDebug(method, "Succeed");
            } else {
                if (result != null) {
                    this.printDebug(method, "Fail: " + result[0].toString());
                    throw new VWException("filenet.pe.WorkflowLaunchingFailWithResult", "Workflow launch has failed with result {0}", result[0].toString());
                }
                if (result == null) {
                    this.printDebug(method, "result of launching is null");
                    throw new VWException("filenet.pe.WorkflowLaunchingResultNull", "Workflow launch returns null for result");
                }
            }
        }
        catch (VWException t) {
            throw t;
        }
        finally {
            session = null;
        }
    }

    private void constructLaunchValues(String[] fields, Object[] values) {
        String method = "constructLaunchValues";
        int numberOfFieldsWithValue = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i] instanceof Object[] && ((Object[])values[i]).length == 0) continue;
            ++numberOfFieldsWithValue;
        }
        this.m_launchFields = new String[numberOfFieldsWithValue];
        this.m_launchValues = new Object[numberOfFieldsWithValue];
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i] instanceof Object[] && ((Object[])values[i]).length == 0) continue;
            this.m_launchFields[j] = fields[i];
            if (this.logger.isFinest()) {
                this.logger.finest(classname, method, fields[i]);
            }
            this.m_launchValues[j] = values[i];
            if (this.logger.isFinest()) {
                this.logger.finest(classname, method, values[i].toString());
            }
            ++j;
        }
    }

    private PEConnectionPoint findPEConnectionPoint(Subscription sub, int region, String service, String connPointName) throws VWException {
        VWException vwe;
        PEConnectionPoint connPoint;
        String method = "findPEConnectionPoint";
        if (this.logger.isFinest()) {
            this.logger.finest(classname, method, "region = " + region + ", service=" + service);
        }
        String servername = null;
        if (service.indexOf(":") > -1) {
            servername = service.substring(service.indexOf(":") + 1, service.lastIndexOf(":"));
            if (this.logger.isFinest()) {
                this.logger.finest(classname, method, "name from service = " + servername);
            }
        }
        ObjectStore objStore = sub.getObjectStore();
        PropertyFilter pf = new PropertyFilter();
        pf.addIncludeProperty(0, null, null, "Domain");
        objStore.fetchProperties(pf);
        Domain domain = objStore.get_Domain();
        PEConnectionPointSet connPointSet = domain.get_PEConnectionPoints();
        Iterator it = connPointSet.iterator();
        ArrayList<PEConnectionPoint> arList = new ArrayList<PEConnectionPoint>();
        while (it.hasNext()) {
            connPoint = (PEConnectionPoint)it.next();
            String name = connPoint.get_Name();
            IsolatedRegion ir = connPoint.get_IsolatedRegion();
            String connPointDNSname = ir.get_DNSName();
            Integer connPointRegion = ir.get_IsolatedRegionNumber();
            if (connPointName != null && name.compareTo(connPointName) == 0) {
                if (this.logger.isFinest()) {
                    this.logger.finest(classname, method, "connectionPoint = " + connPoint.get_Name());
                }
                return connPoint;
            }
            if (connPointName != null || connPointRegion != region) continue;
            if (connPointDNSname.compareToIgnoreCase(servername) == 0) {
                if (this.logger.isFinest()) {
                    this.logger.finest(classname, method, "connectionPoint = " + connPoint.get_Name());
                }
                return connPoint;
            }
            arList.add(connPoint);
        }
        if (arList.size() > 0) {
            connPoint = (PEConnectionPoint)arList.get(0);
            if (this.logger.isFinest()) {
                this.logger.finest(classname, method, "connectionPoint = " + connPoint.get_Name());
            }
            return connPoint;
        }
        if (connPointName != null) {
            this.logger.warning(classname, method, "no connection point found for name = " + connPointName);
            vwe = new VWException("filenet.pe.ce.NoCPForName", "No connection point found with name {0}", connPointName);
            throw vwe;
        }
        this.logger.warning(classname, method, "no connection point found for region = " + region + ", service=" + service);
        vwe = new VWException("filenet.pe.ce.NoCPForRegion", "No connection point found for region {0}", new Integer(region).toString());
        throw vwe;
    }

    private void printDebug(String method, String str) {
        this.logger.info(classname, method, str);
    }

    private void printWarning(String method, String obj) {
        this.logger.warning(classname, method, obj);
    }

    private void printError(String method, Throwable t) {
        this.logger.throwing(classname, method, t);
    }

    private VWSession getVWSession(String vwBootstrapURL) throws VWException {
        String method = "getVWSession";
        VWSession session = new VWSession(vwBootstrapURL);
        if (this.logger.isFinest()) {
            this.logger.finest(classname, method, "created session for bootstrapurl: " + vwBootstrapURL);
        }
        return session;
    }
}

